# Changelog - eazyFind.me PowerSearch Plugin

Wichtige Änderungen und Updates für das eazyFind.me Plugin.

---

## [2.0.9] - 2025-01-18

### Neue Funktionen
- **Exakter Treffer Highlighting** - Visuelle Hervorhebung bei Artikelnummer/GTIN-Match 🎯
  ▪ Grünes Badge "✓ EXAKTER TREFFER" bei 100% Übereinstimmung
  ▪ Funktioniert mit Artikelnummer (SKU) und GTIN/EAN
  ▪ Exakte Treffer erscheinen automatisch zuerst
  ▪ Grüner Border + Gradient-Hintergrund zur Hervorhebung
  ▪ Responsive Design (Mobile + Desktop optimiert)

- **Einstellungen Export/Import** - Backup und Migration leicht gemacht 📦
  ▪ Export aller Plugin-Einstellungen als JSON-Datei
  ▪ Import auf anderem Shop oder nach Plugin-Neuinstallation
  ▪ Zeitstempel im Dateinamen für Versionierung
  ▪ Im Plugin-Backend unter Einstellungen verfügbar

- **History State für Zurück-Button** - Verbesserte Browser-Navigation 🔙
  ▪ Suchmodal-Öffnen wird in Browser-History gespeichert
  ▪ Zurück-Button schließt Modal (statt Seite zu verlassen)
  ▪ DSGVO-konform ohne zusätzliche Cookies
  ▪ Natürlicheres Navigationsverhalten

- **Webhook Secret Auto-Recovery** - Automatische Reparatur bei Updates 🔧
  ▪ Problem: webhook_secret ging bei Plugin-Updates verloren
  ▪ Lösung: Automatisches Abrufen vom Backend wenn leer
  ▪ Kein manueller Eingriff mehr nötig

- **Tarif-Limits Prüfung** - Transparente Anzeige bei Limitüberschreitung ⚠️
  ▪ Plugin prüft plugin_active Status vom Backend
  ▪ Bei Limitüberschreitung: Kritische Warnung im Admin-Dashboard
  ▪ Link zum Upgrade direkt im Dashboard
  ▪ Such-Modal wird bei inaktivem Status nicht registriert

### CRITICAL: Fehlerbehebungen
- **Aktuelle Preise für alle Besucher** 💰
  ▪ Problem: Nicht eingeloggte Besucher sahen gecachte (veraltete) Preise
  ▪ Lösung: Artikel werden IMMER frisch geladen (fuelleArtikel)
  ▪ Aktionspreise, Sonderangebote und zeitlich begrenzte Rabatte sofort sichtbar
  ▪ Trade-off: ~15-20ms mehr pro Produkt, aber 100% aktuelle Preise

- **Live Lagerbestand** 📦
  ▪ Problem: Gecachte Suchergebnisse zeigten veralteten Bestand
  ▪ Lösung: Direkter DB-Query für Lagerbestand statt Cache
  ▪ Echtzeitanzeige des verfügbaren Bestands

- **Warenkorb-Buttons funktionieren wieder** 🛒
  ▪ Problem: Plugin hat fälschlicherweise Warenkorb-Buttons als Such-Buttons erkannt
  ▪ Lösung: Intelligente Button-Erkennung mit expliziter Ausschlussliste
  ▪ Ausgeschlossen: cart-items-delete, droppos, add-to-cart, remove-from-cart, etc.
  ▪ Betrifft: Produktseite Warenkorb-Button, Warenkorb-Entfernen-Button

### Technische Änderungen
- search-api.php: Stock-Daten aus Artikel-Objekt statt separater DB-Query
- Bootstrap.php: refetchWebhookSecret() Methode für Auto-Recovery
- zhz-search-override.js: History State API Integration
- adminmenu/settings.php: Export/Import UI + Backend-Logik
- get-settings.php: Parse plugin_status von Backend API

---

## [2.0.8] - 2025-12-25

### CRITICAL: Mehrsprachigkeit - SEO-URL Query korrigiert 🔧
- **Problem**: Contextual Recommendations (Kunden kauften auch, Top Produkte) verlinkten falsch auf deutsche URLs trotz Sprachwechsel
- **Ursache**: Falsche `tseo` Tabellen-Query verwendete `selectSingleRow` mit falscher Syntax
- **Fix**: Korrekte Query mit `executeQueryPrepared` und richtiger WHERE-Clause
  - `WHERE cKey = 'kArtikel' AND kKey = ? AND kSprache = ?`
  - Verwendet `kKey` (Artikel-ID) statt `kArtikel`
- **Betrifft**: `get-product-recommendations.php`, `get-category-top-products.php`
- **Ergebnis**: Produktlinks jetzt korrekt in gewählter Sprache ✅

### Mehrsprachigkeit - Filter-Übersetzungen vervollständigt 🌍
- **Problem**: Zusatzfilter im Modal nur auf Deutsch ("Zusatzfilter", "Neu", "Top", "Sale", "Auf Lager", "Keine Merkmale verfügbar")
- **Fix**: 6 neue Translation-Keys für alle 17 Sprachen hinzugefügt + JavaScript angepasst
  - `zhz_filter_additional` - Zusatzfilter / Additional Filters / ...
  - `zhz_filter_new` - Neu / New / ...
  - `zhz_filter_top` - Top / Top / ...
  - `zhz_filter_sale` - Sale / Sale / ...
  - `zhz_filter_instock` - Auf Lager / In Stock / ...
  - `zhz_filter_no_attributes` - Keine Merkmale verfügbar / No attributes available / ...
- **Sprachen**: DE, EN, FR, IT, ES, NL, PL, PT, CS, SK, HU, RO, BG, SV, DA, FI, EL
- **Betrifft**: `get-settings.php`, `zhz-search-override.js`

---

## [2.0.8] - 2025-12-24

### Tracking-System Vereinheitlichung 🎯
- **EIN einziges Tracking-System** - Migration abgeschlossen
  - ❌ ALT: Zwei Systeme (trackClick → Backend API, trackCartEvent → track-event.php)
  - ✅ NEU: Nur noch track-event.php für ALLE Events (search, click, add_to_cart, purchase)
  - Globaler Click-Handler entfernt (war redundant)
  - trackClick() Funktion entfernt
  - Alle Handler nutzen jetzt trackCartEvent()
  - Backend-kompatibel mit cart_tracking_events Tabelle
  - Betrifft: zhz-search-override.js, track-event.php

### Neue Funktionen
- **Contextual Recommendations Tracking** - Vollständiges Click- und Warenkorb-Tracking
  - Alle Klicks auf Empfehlungen werden erfasst (Customers Also Bought, Similar Products, Category Top)
  - Section-basiertes Tracking (z.B. "customers-also-bought", "similar-products", "top-products")
  - Automatisches Add-to-Cart Matching über Session-Hash
  - Position und Produktdaten werden wie bei normaler Suche getrackt
  - Backend erkennt automatisch: Search Results (query) vs Contextual (section)

- **Contextual Recommendations Mehrsprachigkeit** - Korrekte Sprachausgabe in allen Sprachen
  - Produktdaten werden automatisch in aktueller Shop-Sprache geladen
  - Automatischer Fallback auf Deutsch bei fehlenden Übersetzungen
  - Sprache wird aus URL-Parameter gelesen (lang=eng/ger/fre)
  - Unterstützt Query-Parameter URLs (a=684, k=10) und SEO-URLs
  - Betrifft: get-product-recommendations.php, get-category-top-products.php

### Fehlerbehebungen
- **CRITICAL: Session-Hash bleibt jetzt persistent über Checkout-Prozess** 🔐
  - Problem: JTL regeneriert Session-ID während Checkout (Session Fixation Protection)
  - Folge: Click → Add-to-Cart → Purchase Attribution fehlgeschlagen (verschiedene Hashes)
  - Lösung: Tracking-Hash in separatem Session-Key (`$_SESSION['zhz_tracking_hash']`)
  - ✅ DSGVO-konform: Keine personenbezogenen Daten (zufälliger 64-Zeichen Hash)
  - ✅ Session-basiert: Nutzt bestehende JTL-Session, kein zusätzlicher Cookie
  - ✅ Persistent: Hash bleibt über JTL-Session-Regeneration hinweg erhalten
  - ✅ Einfach: Keine Session-Konflikte, nutzt nur separaten Session-Key
  - Betrifft: track-event.php, Bootstrap.php (3 Hooks: 126, 205, 228)

- **CRITICAL: MwSt-Berechnung korrigiert** 💰
  - Problem: Purchase-Tracking sendete Netto-Preise statt Brutto (MwSt-Satz war 0)
  - Lösung: 3 Fallbacks für MwSt-Satz (`fMwSt`, `fMwStSatz`, `Artikel->fMwSt`)
  - Beispiel: 2,39 € Netto + 19% MwSt = 2,84 € Brutto ✅
  - Betrifft: Bootstrap.php Purchase-Hook (Zeile 1294-1317)

- **CRITICAL: Backend-Endpoint Migration** 🔄
  - Problem: Alte Analytics-Endpoints existieren nicht mehr (Migration zu cart_tracking_events)
  - ❌ Alt: `/api/v1/analytics/top-performing-products` (gelöscht)
  - ❌ Alt: `/api/v1/analytics/popular-searches` (gelöscht)
  - ✅ Neu: `/api/v1/tracking/cart-stats?days=90` (Top Products)
  - ✅ Neu: `/api/v1/dashboard/stats?days=30` (Popular Searches)
  - Betrifft: get-top-products.php, get-popular-searches.php

- **CRITICAL: Backend API Response-Struktur korrigiert** 🔧
  - Problem: Falsche Feldnamen nach Backend-Migration
  - Fix get-top-products.php:
    - ❌ Alt: `$cartStatsData['top_clicked']`
    - ✅ Neu: `$cartStatsData['data']['top_products']['clicked']`
  - Fix get-popular-searches.php:
    - ❌ Alt: `$backendData['top_searches']`
    - ✅ Neu: `$backendData['data']['topSearches']` (camelCase)
    - ❌ Alt: `$item['query']`
    - ✅ Neu: `$item['search_query']`
  - Ergebnis: Top Products und Popular Searches funktionieren jetzt ✅

- **CRITICAL: .htaccess - Fehlende Regeln für Contextual Recommendations** 🔒
  - Problem: 403 Forbidden auf get-page-context.php, get-product-recommendations.php, get-category-top-products.php
  - Ursache: Dateien waren nicht in .htaccess whitelisted
  - Fix: 3 neue Frontend-Endpoint-Regeln hinzugefügt (Require all granted)
  - Ergebnis: Contextual Recommendations funktionieren jetzt (Kunden kauften auch, Kategorie Top Products) ✅

- **CRITICAL: Mehrsprachigkeit - Falsche Produkt-URLs bei Contextual Recommendations** 🌍
  - Problem: Bei Sprachwechsel (z.B. Englisch) führten Klicks auf Empfehlungen zur deutschen Produktseite
  - Ursache: `$artikel->cURLFull` liefert immer deutsche URL, ignoriert aktuelle Sprache
  - Fix: SEO-URL sprachspezifisch aus DB holen (wie bei Top Products)
  - Betrifft: get-product-recommendations.php, get-category-top-products.php
  - Ergebnis: Produktlinks jetzt in korrekter Sprache (Englisch → englische URL) ✅

### Technische Änderungen
- track-event.php: Vereinfachte Validierung (nur product_id required, query optional)
- track-event.php: Immer beide Felder in Payload (query: null, section: '')
- zhz-search-override.js: Top Products Handler auf trackCartEvent() umgestellt
- Banner Tracking bleibt separat über Backend API (wie gewünscht)
- Session-Handling: 4 Stellen umgestellt auf separate Session (track-event.php + 3x Bootstrap.php)

---

## [2.0.7] - 2025-12-22

### Neue Funktionen
- **Backend-Triggered Sync** - Echter Hintergrund-Sync ohne Browser-Abhängigkeit
  ▪ Browser kann nach Start geschlossen werden
  ▪ Sync läuft auf dem Server mit unbegrenzter Laufzeit
  ▪ Funktioniert auch bei sehr großen Shops (100.000+ Artikel)
  ▪ Persistente Statusverfolgung in Backend-Datenbank
  ▪ Automatisches Error-Handling und Retry-Logik
  ▪ Nur 3 Buttons: Full Sync, Incremental Sync, Status

- **Live-Status-Updates** - Optionale Echtzeit-Fortschrittsanzeige
  ▪ Status-Polling alle 3 Sekunden
  ▪ Zeigt Fortschritt, synchronisierte Produkte, Dauer
  ▪ Automatische Aktualisierung bis Job abgeschlossen

- **Sync-Historie** - Übersicht über vergangene Synchronisationen
  ▪ Zeigt die letzten 10 Sync-Jobs
  ▪ Job-ID, Typ (Vollständig/Inkrementell), Status, Produkte, Dauer

### Fehlerbehebungen
- **CRITICAL: Multi-Language Fallback System** - Felder-für-Felder Fallback auf Standardsprache
  ▪ Problem: Produkte mit unvollständigen Übersetzungen hatten leere Felder (product_name, description)
  ▪ Lösung: Jedes Feld wird einzeln geprüft und fällt bei Bedarf auf die Standardsprache zurück
  ▪ Betrifft: `product_name`, `description`, `short_description`
  ▪ Verhindert "Server-Fehler nach 3 Versuchen" bei mehrsprachigen Shops

### Technische Änderungen
- `adminmenu/sync.php`: Backend-API-Integration (trigger-full-sync, trigger-incremental-sync, sync-status, sync-history)
- `SyncDataBuilder::getProductLanguageData()` komplett überarbeitet
- Vereinfachte UI mit nur 3 Buttons

---

## [2.0.6] - 2025-12-21

### Neue Funktionen
- **Sprachsuche (Voice Search)** - Suche per Mikrofon auf allen Geräten
  ▪ Desktop und Mobile Unterstützung (Chrome, Edge, Safari)
  ▪ Automatische Spracherkennung (DE, EN, FR, IT, ES, NL, PL)
  ▪ DSGVO-konformer Consent-Dialog beim ersten Klick
  ▪ Echtzeit-Transkription ins Suchfeld
  ▪ Aktivierung/Deaktivierung im Plugin-Backend
  ▪ Touch-optimiert für mobile Geräte

---

## [2.0.5] - 2025-12-18

### Neue Funktionen
- **Banner-Verwaltung** - Enterprise-Feature für Marketing-Banner
  ▪ Desktop und Mobile Banner separat verwaltbar
  ▪ Zeitgesteuerte Anzeige (Start/End-Datum)
  ▪ URL-Verlinkung mit optionalem neuen Tab
  ▪ Suchbegriff-Targeting (z.B. Banner nur bei Suche nach "Ball")
  ▪ Sprach-Targeting (DE, EN, FR etc.)
  ▪ Position: Nach Top-Produkten, vor Suchergebnissen
  ▪ Analytics: Impressions und Klicks werden getrackt
  ▪ Automatische Skalierung und Responsive-Darstellung

### Verbesserungen
- **Session-basierte Spracherkennung** - Fix für mehrsprachige Shops
  ▪ Plugin erkennt jetzt die aktuelle Session-Sprache
  ▪ Früher: Immer Deutsch, auch wenn auf Englisch umgeschaltet
  ▪ Jetzt: Korrekte Sprache für Übersetzungen und Banner-Targeting
  ▪ Verwendet `$_SESSION['kSprache']` mit Fallback zur Standard-Sprache

- **Banner-Clearing bei leerer Suche** - Bessere UX
  ▪ Banner werden entfernt wenn Suche geleert wird
  ▪ Sauberer Übergang zurück zu Top-Produkten

---

## [2.0.4] - 2025-12-17

### Neue Funktionen
- **3-Wert Produkt-Varianten Filter** - Flexibles Filtern nach Produkttypen
  ▪ Alle anzeigen (Väter + Kinder + Normale)
  ▪ Kinder ausblenden (nur Väter + Normale)
  ▪ Väter ausblenden (nur Kinder + Normale)
  ▪ Shop-Admin kann frei entscheiden
  ▪ Gilt für Modal, Autocomplete und Top Produkte

### Verbesserungen
- **Parent-Child Tracking** - Warenkorbtracking erkennt jetzt Varianten-Beziehungen
  ▪ Wenn Vater-Artikel geklickt wird, aber Kind gekauft → Verbindung erkannt
  ▪ Click-to-Purchase Journey wird korrekt erfasst
  ▪ Bessere Analytics für Produkte mit Varianten

- **Unbegrenzte Kategorie-Prioritäten** - Keine Limits mehr
  ▪ Früher: Maximal 0-100
  ▪ Jetzt: Unbegrenzt (nur Negativwerte werden verhindert)
  ▪ Ideal für Marketing-Aktionen mit hohen Prioritäten

- **Kategorie-Hierarchie** - Prioritäten werden vererbt
  ▪ Oberkategorien-Attribute werden berücksichtigt
  ▪ Artikel erbt Priorität von allen Parent-Kategorien
  ▪ Höchster Wert in der Hierarchie wird verwendet

---

## [2.0.3] - 2025-12-16

### Neue Funktionen
- **Top Produkte** - Zeigt Ihre erfolgreichsten Produkte beim Klick ins Suchfeld
  ▪ Automatische Empfehlungen basierend auf Performance-Analytics
  ▪ 3 Profile zur Auswahl: Umsatz-fokussiert, Engagement oder Balanced
  ▪ Frei konfigurierbar (Anzahl, Ein/Aus)
  ▪ Analysezeitraum: Letzte 90 Tage
  ▪ Backend-Endpoint mit Cache für schnelle Ladezeiten
  ▪ Reduziert API-Calls von 2 auf 1

### Verbesserungen
- Suchmodal öffnet sich jetzt sofort beim Klick ins Suchfeld
- Keine Template-Anpassungen mehr erforderlich
- Bessere Kompatibilität mit allen JTL Shop Themes
- Einstellungen kompakter dargestellt (Grid-Layouts)
- Such-Modal: Icons einheitlich grau für konsistentes Design
- Top Produkte zeigen korrekte Preise an
  ▪ Kundengruppen-spezifische Preise
  ▪ Sonderpreise und Rabatte
  ▪ Lagerbestand mit Ampel-Status
  ▪ Alle Produkt-Informationen vollständig

---

## [2.0.0] - 2025-12-14

### Neue Funktionen
- **Bot-Schutz** - Schützt Ihre Suche vor automatisierten Anfragen
  ▪ Intelligente Bot-Erkennung auf 4 Ebenen
  ▪ Rate-Limiting: 50 Anfragen pro 5 Minuten
  ▪ Echte Kunden werden nicht beeinträchtigt
  ▪ SEO-Bots (Google, Bing etc.) werden zugelassen
  ▪ DSGVO-konform ohne personenbezogene Daten

---

## [1.9.9] - 2025-12-01

### Neue Funktionen
- **Warenkorb-Tracking** - Verfolgen Sie die Customer Journey
  ▪ DSGVO-konform ohne Cookies
  ▪ Von der Suche bis zum Kauf
  ▪ Umsatz-Analyse nach Quelle

- **Produkt-Ranking** - Intelligente Sortierung der Suchergebnisse
  ▪ Verkaufszahlen werden berücksichtigt
  ▪ Neue Produkte werden hervorgehoben
  ▪ Manuelle Prioritäten möglich

- **Seiten-Suche** - Auch Inhaltsseiten durchsuchbar
  ▪ AGB, Datenschutz etc. in Suche integriert
  ▪ SEO-optimierte Ergebnisse

- **Kategorie-Filter** - Filtern nach Produktkategorien
  ▪ Mehrsprachig
  ▪ Hierarchische Struktur

### Verbesserungen
- Schnellere Ladezeiten durch optimiertes Caching
- Bessere Mobile-Darstellung
- Erweiterte Dashboard-Statistiken

---

## [1.8.9] - 2025-09-10

### Neue Funktionen
- **Modal-Suche** - Vollbild-Suchmodal mit anpassbarem Design
  ▪ Individuell gestaltbar (Farben, Formen, Layout)
  ▪ 1-5 Spalten einstellbar
  ▪ Direktaufruf per URL möglich

- **Filter-System**
  ▪ Nach Kategorie filtern
  ▪ Preis-Bereich wählen
  ▪ Nach Produktmerkmalen filtern

- **Lagerbestand-Anzeige**
  ▪ Ampel-System (rot/gelb/grün)
  ▪ Nicht verfügbare Artikel optional ausblenden

### Verbesserungen
- Schnellere Synchronisation (nur geänderte Artikel)
- Mehrsprachigkeit: Deutsch, Englisch, Französisch
- Optimierte Performance

---

## [1.7.0] - 2025-08-28

### Erste Version
- Fehlertolerante Suche mit Tippfehler-Korrektur
- Live-Vorschläge während der Eingabe
- Produktbilder in Suchergebnissen
- Automatische Synchronisation
- Admin-Dashboard mit Statistiken

---

## Support

- **Plugin-Homepage**: https://www.10hoch2.de
- **Backend-Service**: https://search01.eazyfind.me
- **Support**: support@10hoch2.de

---

## Lizenz

Proprietary - Copyright © 2025 10hoch2 | Alexander Erlenbusch
