{* ZHZ eazyFind.me - Footer Extension *}
{block name='layout-footer' append}
    {* Modal Container + JavaScript Loader *}
    <div id="zhz-modal-container"></div>

    {* Early-Loading Click Handler: Fängt Clicks ab bevor JS geladen ist *}
    <script>
    (function() {
        // Globale Flag damit zhz-search-override.js weiß dass Early Handler aktiv ist
        window.zhzEarlyHandlerActive = true;
        window.zhzPendingClicks = [];

        // Wartet bis Modal bereit ist und führt gespeicherte Clicks aus
        window.zhzExecutePendingClicks = function() {
            if (window.zhzPendingClicks && window.zhzPendingClicks.length > 0) {
                console.log('🚀 [Early Handler] Executing', window.zhzPendingClicks.length, 'pending clicks');
                window.zhzPendingClicks.forEach(function(input) {
                    if (input && typeof input.click === 'function') {
                        setTimeout(function() { input.click(); }, 50);
                    }
                });
                window.zhzPendingClicks = [];
            }
        };

        // Click-Handler der sofort verfügbar ist (CAPTURE phase!)
        document.addEventListener('click', function(e) {
            // Prüfe ob es ein Suchfeld ist (erweiterte Selektoren)
            var target = e.target;
            var isSearchField = target.matches && (
                target.matches('input[name="qs"]') ||
                target.matches('input[name="search"]') ||
                target.matches('#search') ||
                target.matches('#search-header') ||
                target.matches('#searchInput') ||
                target.matches('.search-field') ||
                target.matches('[data-search-input]')
            );

            if (isSearchField) {
                // Prüfe ob zhz-search-override.js schon geladen ist
                if (typeof window.zhzModalReady === 'undefined') {
                    console.log('⏳ [Early Handler] Click abgefangen - warte auf JS Load...');
                    e.stopImmediatePropagation();
                    e.preventDefault();

                    // Speichere Input für später
                    if (window.zhzPendingClicks.indexOf(target) === -1) {
                        window.zhzPendingClicks.push(target);
                    }

                    return false;
                }
            }
        }, true); // CAPTURE phase = vor allen anderen Handlern

        console.log('✅ [Early Handler] Aktiviert - fängt Clicks vor JS-Load ab');
    })();
    </script>

    <script src="{$ShopURL}/plugins/zhz_eazyfindme/frontend/js/zhz-search-override.js?v={time()}" defer></script>
{/block}
